/*
 * Decompiled with CFR 0.152.
 */
package com.raoulvdberge.refinedstorage.network;

import com.raoulvdberge.refinedstorage.api.network.grid.IGrid;
import com.raoulvdberge.refinedstorage.container.ContainerCraftingMonitor;
import com.raoulvdberge.refinedstorage.container.ContainerGrid;
import com.raoulvdberge.refinedstorage.network.MessageHandlerPlayerToServer;
import io.netty.buffer.ByteBuf;
import java.util.UUID;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class MessageCraftingCancel
extends MessageHandlerPlayerToServer<MessageCraftingCancel>
implements IMessage {
    private UUID taskId;

    public MessageCraftingCancel() {
    }

    public MessageCraftingCancel(UUID taskId) {
        this.taskId = taskId;
    }

    public void fromBytes(ByteBuf buf) {
        if (buf.readBoolean()) {
            this.taskId = new UUID(buf.readLong(), buf.readLong());
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeBoolean(this.taskId != null);
        if (this.taskId != null) {
            buf.writeLong(this.taskId.getMostSignificantBits());
            buf.writeLong(this.taskId.getLeastSignificantBits());
        }
    }

    @Override
    public void handle(MessageCraftingCancel message, EntityPlayerMP player) {
        IGrid grid;
        if (player.field_71070_bA instanceof ContainerCraftingMonitor) {
            ((ContainerCraftingMonitor)player.field_71070_bA).getCraftingMonitor().onCancelled(player, message.taskId);
        } else if (player.field_71070_bA instanceof ContainerGrid && (grid = ((ContainerGrid)player.field_71070_bA).getGrid()).getItemHandler() != null) {
            grid.getItemHandler().onCraftingCancelRequested(player, message.taskId);
        }
    }
}

